<?php
header("Content-Type: application/json");
include '../connection.php';

$outlet_name = $_POST['outlet_name'] ?? '';
$address = $_POST['address'] ?? '';
$latitude = $_POST['latitude'] ?? '';
$longitude = $_POST['longitude'] ?? '';
$employee_id = $_POST['employee_id'] ?? null;
$status = $_POST['status'] ?? 1;

if (empty($outlet_name) || empty($address) || empty($latitude) || empty($longitude)) {
    echo json_encode(["success" => false, "message" => "All fields are required"]);
    exit;
}

$sql = "INSERT INTO tbl_outlet (outlet_name, address, latitude, longitude, assigned_employee_id, status)
        VALUES (?, ?, ?, ?, ?, ?)";

$stmt = $conn->prepare($sql);
$stmt->bind_param("ssddii", $outlet_name, $address, $latitude, $longitude, $employee_id, $status);

if ($stmt->execute()) {
    echo json_encode(["success" => true, "message" => "Outlet added successfully."]);
} else {
    echo json_encode(["success" => false, "message" => "Failed to add outlet."]);
}
?>

