<?php
/*
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
include '../connection.php';

if (!isset($_POST['id'])) {
    echo json_encode(["success" => false, "message" => "Missing ID"]);
    exit;
}

$id = intval($_POST['id']);

// Step 1: Fetch existing image filename
$getImageQuery = "SELECT icon FROM tbl_product_type WHERE id = ?";
$stmt = $conn->prepare($getImageQuery);
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$row = $result->fetch_assoc();
$stmt->close();

if (!$row) {
    echo json_encode(["success" => false, "message" => "Record not found"]);
    $conn->close();
    exit;
}

$iconFile = $row['icon'];

// Step 2: Delete the database record
$deleteQuery = "DELETE FROM tbl_product_type WHERE id = ?";
$stmt = $conn->prepare($deleteQuery);
$stmt->bind_param("i", $id);

if ($stmt->execute()) {
    // Step 3: Delete image file if exists
    if (!empty($iconFile)) {
        $imagePath = __DIR__ . "../uploadicon/product_icons/" . $iconFile;
        if (file_exists($imagePath)) {
            unlink($imagePath); // Delete the image file
        }
    }
    echo json_encode(["success" => true]);
} else {
    echo json_encode(["success" => false, "message" => $stmt->error]);
}

$stmt->close();
$conn->close();
*/
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
include '../connection.php';

if (!isset($_POST['id'])) {
    echo json_encode(["success" => false, "message" => "Missing ID"]);
    exit;
}

$id = intval($_POST['id']);

// Step 1: Check if product type is used in tbl_service_product_prices
$checkUsageQuery = "SELECT COUNT(*) AS count FROM tbl_service_product_prices WHERE product_id = ?";
$stmt = $conn->prepare($checkUsageQuery);
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$usage = $result->fetch_assoc();
$stmt->close();

if ($usage && $usage['count'] > 0) {
    echo json_encode([
        "success" => false,
        "message" => "Cannot delete: This product type is already used in service price records."
    ]);
    $conn->close();
    exit;
}

// Step 2: Fetch existing image filename
$getImageQuery = "SELECT icon FROM tbl_product_type WHERE id = ?";
$stmt = $conn->prepare($getImageQuery);
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$row = $result->fetch_assoc();
$stmt->close();

if (!$row) {
    echo json_encode(["success" => false, "message" => "Record not found"]);
    $conn->close();
    exit;
}

$iconFile = $row['icon'];

// Step 3: Delete the database record
$deleteQuery = "DELETE FROM tbl_product_type WHERE id = ?";
$stmt = $conn->prepare($deleteQuery);
$stmt->bind_param("i", $id);

if ($stmt->execute()) {
    // Step 4: Delete image file if exists
    if (!empty($iconFile)) {
        $imagePath = __DIR__ . "/../uploadicon/product_icons/" . $iconFile;
        if (file_exists($imagePath)) {
            unlink($imagePath); // Delete the image file
        }
    }
    echo json_encode(["success" => true, "message" => "Product type deleted successfully"]);
} else {
    echo json_encode(["success" => false, "message" => $stmt->error]);
}

$stmt->close();
$conn->close();
?>