<?php

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json; charset=UTF-8");

include '../connection.php';

// Handle preflight CORS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    if (empty($_POST['order_id'])) {
        echo json_encode(["success" => false, "message" => "Missing order_id"]);
        exit;
    }

    $orderId = intval($_POST['order_id']);
    if ($orderId <= 0) {
        echo json_encode(["success" => false, "message" => "Invalid order_id value"]);
        exit;
    }

    try {
        // Start transaction
        $conn->begin_transaction();

        // 1️⃣ Delete related order items first
        $stmt1 = $conn->prepare("DELETE FROM tbl_order_items WHERE order_id = ?");
        if (!$stmt1) {
            throw new Exception("Failed to prepare delete order items: " . $conn->error);
        }
        $stmt1->bind_param("i", $orderId);
        $stmt1->execute();
        $stmt1->close();

        // 2️⃣ Delete main order record
        $stmt2 = $conn->prepare("DELETE FROM tbl_order WHERE id = ?");
        if (!$stmt2) {
            throw new Exception("Failed to prepare delete order: " . $conn->error);
        }
        $stmt2->bind_param("i", $orderId);
        $stmt2->execute();

        if ($stmt2->affected_rows === 0) {
            throw new Exception("Order not found or already deleted");
        }

        $stmt2->close();

        // ✅ Commit transaction
        $conn->commit();

        echo json_encode([
            "success" => true,
            "message" => "Order deleted successfully"
        ]);

    } catch (Exception $e) {
        if ($conn->in_transaction) {
            $conn->rollback();
        }

        echo json_encode([
            "success" => false,
            "message" => "Delete failed: " . $e->getMessage()
        ]);
    }

} else {
    echo json_encode(["success" => false, "message" => "Invalid request method"]);
}


/*
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

include '../connection.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!isset($_POST['order_id'])) {
        echo json_encode(["success" => false, "message" => "Missing order_id"]);
        exit;
    }

    $orderId = intval($_POST['order_id']);

    try {
        // Start transaction
        $conn->begin_transaction();

        // Delete order items first
        $stmt1 = $conn->prepare("DELETE FROM tbl_order_items WHERE order_id = ?");
        $stmt1->bind_param("i", $orderId);
        $stmt1->execute();
        $stmt1->close();

        // Delete order
        $stmt2 = $conn->prepare("DELETE FROM tbl_order WHERE id = ?");
        $stmt2->bind_param("i", $orderId);
        $stmt2->execute();
        $stmt2->close();

        // Commit
        $conn->commit();

        echo json_encode(["success" => true, "message" => "Order deleted successfully"]);
    } catch (Exception $e) {
        $conn->rollback();
        echo json_encode(["success" => false, "message" => "Delete failed: " . $e->getMessage()]);
    }
} else {
    echo json_encode(["success" => false, "message" => "Invalid request"]);
}

/*