<?php
header("Access-Control-Allow-Origin: *");
header('Content-Type: application/json');
include '../db_connection.php';

$user_id = $_POST['user_id'];
$order_id = $_POST['order_id'];
$address = $_POST['address'];
$latitude = $_POST['latitude'];
$longitude = $_POST['longitude'];

if (!$user_id || !$order_id) {
    echo json_encode(["success" => false, "message" => "Missing required fields"]);
    exit;
}

$stmt = $conn->prepare("INSERT INTO tbl_pickup_location (user_id, order_id, address, latitude, longitude) VALUES (?, ?, ?, ?, ?)");
$stmt->bind_param("iissd", $user_id, $order_id, $address, $latitude, $longitude);

if ($stmt->execute()) {
    echo json_encode(["success" => true, "message" => "Pickup location saved"]);
} else {
    echo json_encode(["success" => false, "message" => "Database error"]);
}
